const nodemailer = require("nodemailer");
require("dotenv").config();

const transporter = nodemailer.createTransport({
  service: "gmail",
  auth: {
    user: process.env.SMTP_EMAIL,
    pass: process.env.SMTP_PASSWORD,
  },
});

/**
 * @param {string} to - Receiver's email
 * @param {string} subject - Email subject
 * @param {string} text - Email body
 * @param {Object} [attachment] - Optional attachment
 * @returns {Promise<void>}
 */
const sendEmail = async (to, subject, text, attachment = null) => {
  const mailOptions = {
    from: `MendingMind ${process.env.SMTP_EMAIL}`,
    to,
    subject,
    text,
    attachments: attachment ? [attachment] : [],
  };

  await transporter.sendMail(mailOptions);
};

module.exports = sendEmail;
