const validateInstallmentsBeforeBooking = (bundle, currentSessionCount) => {
  const { installments } = bundle;

  for (const installment of installments) {
    if (
      installment.dueSessionNumber <= currentSessionCount &&
      installment.status === "pending"
    ) {
      return {
        valid: false,
        message: `Please clear installment due at session ${installment.dueSessionNumber + 1}`,
      };
    }
  }

  return { valid: true };
};

module.exports = validateInstallmentsBeforeBooking;
