const express = require("express");
const userController = require("../../controller/user/userController");
const planController = require("../../controller/user/planController");
const upload = require("../../middleware/upload");
const {
  verifyToken,
  isDoctor,
  isAdmin,
  isUser,
} = require("../../middleware/authMiddleware");

const router = express.Router();

router.post("/therapy-flow", verifyToken, isUser, userController.therapyFlow);
router.post(
  "/therapy-general-question",
  verifyToken,
  isUser,
  userController.therapyGeneralQuestions
);
router.post(
  "/therapy/step3",
  verifyToken,
  isUser,
  userController.updateStep3TherapyDetails
);

//Psychometrics
router.post(
  "/Psychometrics/store",
  verifyToken,
  isUser,
  userController.savePsychometricStep1
);

//CorporateWellness
router.post(
  "/corporateWellness",
  verifyToken,
  isUser,
  userController.submitCorporateWellness
);

//Internship
router.post(
  "/internship",
  verifyToken,
  isUser,
  userController.submitInternshipForm
);

router.get(
  "/session/request",
  verifyToken,
  isUser,
  userController.createSessionRequest
);

router.post("/add-plan", planController.addPlan);

router.post("/select-plan", verifyToken, isUser, planController.selectPlan);
router.get(
  "/get-selectedplan",
  verifyToken,
  isUser,
  planController.getSelectedPlan
);

router.get("/get-plans", verifyToken, isUser, planController.getAllPlans);

//client panel
router.get(
  "/session-summary",
  verifyToken,
  isUser,
  userController.getSessionSummary
);
router.get(
  "/today-session",
  verifyToken,
  isUser,
  userController.getTodaySession
);

router.get("/user-session", verifyToken, isUser, userController.userSessions);
router.get("/plan-session", verifyToken, isUser, userController.planSessions);

router.get(
  "/upcoming-session",
  verifyToken,
  isUser,
  userController.getUpcomingSession
);

router.get("/therapy-plan", verifyToken, isUser, userController.getTherapyPlan);

router.get(
  "/therapy-notes",
  verifyToken,
  isUser,
  userController.getTherapyNotes
);

router.get(
  "/therapy-pricing",
  verifyToken,
  isUser,
  userController.gettherapypricing
);

router.get("/profile", verifyToken, userController.getUserProfile);

router.patch("/update-profile", verifyToken, userController.updateUserProfile);

router.post(
  "/plan-pdf",
  verifyToken,
  upload.single("pdf"),
  userController.planPdf
);

router.post("/get-my-plan", verifyToken, isUser, userController.getMyPlan);

router.post("/accept-plan", verifyToken, isUser, userController.acceptPlan);

module.exports = router;
