const express = require("express");
const paymentController = require("../../controller/user/paymentController.js");

const {
  verifyToken,
  isDoctor,
  isAdmin,
  isUser,
} = require("../../middleware/authMiddleware");

const router = express.Router();

router.post("/initiate-payment", verifyToken, paymentController.initiatePayment);
router.post("/verify-payment", verifyToken, paymentController.verifyPayment);

router.post("/verify-event-payment", paymentController.verifyEventPayment);

module.exports = router;
