const express = require("express");
const bundleController = require("../../controller/user/bundleController");
const {
  verifyToken,
  isDoctor,
  isAdmin,
  isUser,
} = require("../../middleware/authMiddleware");

const router = express.Router();

router.get(
  "/get-installments/:id",
  verifyToken,
  isUser,
  bundleController.getInstallments
);

router.post(
  "/pay-installment/:id",
  verifyToken,
  isUser,
  bundleController.payInstallment
);

router.post(
  "/bookbundle-appointment",
  verifyToken,
  isUser,
  bundleController.bookBundelAppointment
);

router.get(
  "/get-planamount",
  verifyToken,
  isUser,
  bundleController.getPlanAmount
);

router.post(
  "/book-individual-appointment",
  verifyToken,
  isUser,
  bundleController.bookAppointment
);

router.post(
  "/installments-create/:id",
  verifyToken, // optional, if you require the user to be logged in
  bundleController.createInstallmentPayment
);
router.post(
  "/installments-verify",
  verifyToken,
  bundleController.verifyInstallmentPayment
);

router.post("/initiate-payment", verifyToken, bundleController.initiatePayment);
router.post("/verify-payment", verifyToken, bundleController.verifyPayment);

module.exports = router;
