const express = require("express");
const router = express.Router();
const { verifyToken } = require("../middleware/authMiddleware");
const {
  getUserNotifications,
  markNotificationAsRead,
  markAllNotificationsAsRead,
  archiveNotification,
  getActionRequiredNotifications,
  getNotificationStats,
  sendAvailabilityReminder
} = require("../controller/notificationController");

// Apply auth middleware to all routes
router.use(verifyToken);

// Get notifications for current user
router.get("/", getUserNotifications);

// Get notifications requiring action
router.get("/action-required", getActionRequiredNotifications);

// Get notification statistics
router.get("/stats", getNotificationStats);

// Mark specific notification as read
router.put("/:notificationId/read", markNotificationAsRead);

// Mark all notifications as read
router.put("/read-all", markAllNotificationsAsRead);

// Archive notification
router.put("/:notificationId/archive", archiveNotification);

// Send availability reminder (admin only)
router.post("/availability-reminder", sendAvailabilityReminder);

module.exports = router;
