const express = require("express");
const router = express.Router();
const { verifyToken } = require("../../middleware/authMiddleware");
const {
  getTherapistProfile,
  updateBasicInfo,
  updateTherapyPreferences,
  updateAvailability,
  updateNotificationPreferences,
  updateAccountSettings,
  updateCertifications,
  getAvailabilityForDate
} = require("../../controller/doctor/therapistProfileController");

// Middleware to ensure only doctors can access these routes
const doctorOnly = (req, res, next) => {
  if (req.user.role !== 'doctor') {
    return res.status(403).json({
      success: false,
      message: "Access denied. Only therapists can access this resource."
    });
  }
  next();
};

// Apply auth middleware to all routes
router.use(verifyToken);
router.use(doctorOnly);

// GET /api/doctor/profile - Get therapist profile
router.get("/profile", getTherapistProfile);

// PUT /api/doctor/profile/basic - Update basic information
router.put("/profile/basic", updateBasicInfo);

// PUT /api/doctor/profile/therapy-preferences - Update therapy delivery preferences
router.put("/profile/therapy-preferences", updateTherapyPreferences);

// PUT /api/doctor/profile/availability - Update availability settings
router.put("/profile/availability", updateAvailability);

// PUT /api/doctor/profile/notifications - Update notification preferences
router.put("/profile/notifications", updateNotificationPreferences);

// PUT /api/doctor/profile/account - Update account settings
router.put("/profile/account", updateAccountSettings);

// PUT /api/doctor/profile/certifications - Update certifications
router.put("/profile/certifications", updateCertifications);

// GET /api/doctor/profile/availability - Get availability for specific date
router.get("/profile/availability", getAvailabilityForDate);

module.exports = router;
