const express = require("express");
const doctorController = require("../../controller/doctor/sessionController");
const {
  verifyToken,
  isDoctor,
  isAdmin,
  isUser,
} = require("../../middleware/authMiddleware");
const upload = require("../../middleware/upload");

const router = express.Router();

router.get(
  "/appointments",
  verifyToken,
  isDoctor,
  doctorController.getAllDoctorAppointments
);

router.get(
  "/session-request/get",
  verifyToken,
  isDoctor,
  doctorController.getDoctorSessionRequests
);
router.post(
  "/session/accept",
  verifyToken,
  isDoctor,
  doctorController.acceptSessionRequest
);
router.post(
  "/session/cancel",
  verifyToken,
  isDoctor,
  doctorController.cancelAppointment
);

router.post(
  "/session/compelte",
  verifyToken,
  isDoctor,
  doctorController.completeAppointment
);

router.post(
  "/session/notes",
  verifyToken,
  isDoctor,
  doctorController.addNotesToAppointment
);

router.post(
  "/session/attachpdf",
  verifyToken,
  isDoctor,
  upload.single("appointmentPdf"),
  doctorController.attachPdfToAppointment
);

router.get(
  "/today-appointments",
  verifyToken,
  isDoctor,
  doctorController.getTodayAppointments
);

router.get(
  "/usertherapy-details",
  verifyToken,
  isDoctor,
  doctorController.userTherapyDetails
);

router.get(
  "/upcoming-appointments",
  verifyToken,
  isDoctor,
  doctorController.getUpcomingAppointments
);

router.get(
  "/session/stats",
  verifyToken,
  isDoctor,
  doctorController.getDoctorSessionStats
);
router.get(
  "/get-doctors-selected-slots",
  verifyToken,
  isDoctor,
  doctorController.getDoctorsSelectedSlots
);

router.get(
  "/session/stats",
  verifyToken,
  isDoctor,
  doctorController.getDoctorSessionStats
);

router.post(
  "/completed-appointments",
  verifyToken,
  isDoctor,
  doctorController.completeAppointment
);

router.get(
  "/plans-details",
  verifyToken,
  isDoctor,
  doctorController.planDetails
);
router.post("/add-plans", verifyToken, isDoctor, doctorController.addPlan);
router.patch(
  "/edit-plans/:planId",
  verifyToken,
  isDoctor,
  doctorController.editPlan
);

router.get(
  "/get-plan/:userId",
  verifyToken,
  isDoctor,
  doctorController.getPlanByDoctorAndUser
);

router.post(
  "/update-status",
  verifyToken,
  isDoctor,
  doctorController.updateAppointmentStatus
);

module.exports = router;
