const express = require("express");
const router = express.Router();
const { verifyToken, isDoctor } = require("../../middleware/authMiddleware");
const dashboardController = require("../../controller/doctor/dashboardController");

/**
 * @route GET /api/doctor/dashboard
 * @desc Get complete dashboard data for therapist
 * @access Private (Doctor only)
 * @query period - Optional: 'month', 'quarter', 'year' (default: 'month')
 */
router.get("/", verifyToken, isDoctor, dashboardController.getDashboardData);

/**
 * @route GET /api/doctor/dashboard/quick-glance
 * @desc Get Quick Glance KPIs for today
 * @access Private (Doctor only)
 */
router.get("/quick-glance", verifyToken, isDoctor, dashboardController.getQuickGlance);

/**
 * @route GET /api/doctor/dashboard/impact-tracker
 * @desc Get Impact Tracker metrics
 * @access Private (Doctor only)
 * @query period - Optional: 'month', 'quarter', 'year' (default: 'month')
 */
router.get("/impact-tracker", verifyToken, isDoctor, dashboardController.getImpactTracker);

/**
 * @route GET /api/doctor/dashboard/client-flow
 * @desc Get Client Flow Insights
 * @access Private (Doctor only)
 * @query period - Optional: 'month', 'quarter', 'year' (default: 'month')
 */
router.get("/client-flow", verifyToken, isDoctor, dashboardController.getClientFlow);

/**
 * @route GET /api/doctor/dashboard/stay-on-track
 * @desc Get Stay on Track alerts and pending tasks
 * @access Private (Doctor only)
 */
router.get("/stay-on-track", verifyToken, isDoctor, dashboardController.getStayOnTrack);

module.exports = router;
