const express = require("express");
const router = express.Router();
const { verifyToken } = require("../../middleware/authMiddleware");
const {
  getTherapistAvailability,
  updateWeeklyAvailability,
  addOneTimeSlot,
  markUnavailableDates,
  getAvailableSlotsForDate,
  updateAvailabilitySettings,
  getPendingChanges,
  previewAvailabilityChanges
} = require("../../controller/doctor/availabilityController");

// Middleware to ensure only doctors can access these routes
const doctorOnly = (req, res, next) => {
  if (req.user.role !== 'doctor') {
    return res.status(403).json({
      success: false,
      message: "Access denied. Only therapists can access this resource."
    });
  }
  next();
};

// Apply auth middleware to all routes
router.use(verifyToken);
router.use(doctorOnly);

// Get therapist's current availability
router.get("/", getTherapistAvailability);

// Update weekly recurring availability (requires admin approval)
router.put("/weekly", updateWeeklyAvailability);

// Add one-time availability slot (requires admin approval)
router.post("/one-time-slot", addOneTimeSlot);

// Mark dates as unavailable (requires admin approval)
router.post("/unavailable-dates", markUnavailableDates);

// Get available slots for a specific date (for client preview)
router.get("/slots", getAvailableSlotsForDate);

// Update availability settings
router.put("/settings", updateAvailabilitySettings);

// Get pending changes
router.get("/pending-changes", getPendingChanges);

// Preview how availability changes would look to clients
router.post("/preview", previewAvailabilityChanges);

module.exports = router;
