const express = require("express");
const router = express.Router();
const { verifyToken } = require("../../middleware/authMiddleware");
const {
  findMatchingTherapists,
  bookAppointmentWithTherapist,
  getTherapistAvailabilityCalendar
} = require("../../controller/appointment/matchingController");

// Apply auth middleware to all routes
router.use(verifyToken);

// POST /api/appointments/find-therapists - Find matching therapists
router.post("/find-therapists", findMatchingTherapists);

// POST /api/appointments/book - Book appointment with selected therapist
router.post("/book", bookAppointmentWithTherapist);

// GET /api/appointments/therapist-calendar - Get therapist availability calendar
router.get("/therapist-calendar", getTherapistAvailabilityCalendar);

module.exports = router;
