const express = require("express");
const router = express.Router();
const { verifyToken } = require("../../middleware/authMiddleware");
const {
  getPendingApprovals,
  getTherapistProfileForReview,
  approveTherapistProfile,
  rejectTherapistProfile,
  requestChanges,
  getApprovalStatistics,
  bulkApproveProfiles,
  deactivateTherapistProfile
} = require("../../controller/admin/therapistApprovalController");

// Middleware to ensure only admins can access these routes
const adminOnly = (req, res, next) => {
  if (req.user.role !== 'admin') {
    return res.status(403).json({
      success: false,
      message: "Access denied. Only admins can access this resource."
    });
  }
  next();
};

// Apply auth middleware to all routes
router.use(verifyToken);
router.use(adminOnly);

// GET /api/admin/therapists/approvals - Get therapist profiles pending approval
router.get("/approvals", getPendingApprovals);

// GET /api/admin/therapists/statistics - Get approval statistics
router.get("/statistics", getApprovalStatistics);

// GET /api/admin/therapists/:therapistId/review - Get specific therapist profile for review
router.get("/:therapistId/review", getTherapistProfileForReview);

// PUT /api/admin/therapists/:therapistId/approve - Approve therapist profile
router.put("/:therapistId/approve", approveTherapistProfile);

// PUT /api/admin/therapists/:therapistId/reject - Reject therapist profile
router.put("/:therapistId/reject", rejectTherapistProfile);

// PUT /api/admin/therapists/:therapistId/request-changes - Request changes to therapist profile
router.put("/:therapistId/request-changes", requestChanges);

// PUT /api/admin/therapists/:therapistId/deactivate - Deactivate therapist profile
router.put("/:therapistId/deactivate", deactivateTherapistProfile);

// PUT /api/admin/therapists/bulk-approve - Bulk approve multiple therapist profiles
router.put("/bulk-approve", bulkApproveProfiles);

module.exports = router;
