const express = require("express");
const codeController = require("../../controller/admin/codeController");
const {
  verifyToken,
  isDoctor,
  isAdmin,
  isUser,
} = require("../../middleware/authMiddleware");
const router = express.Router();

router.post("/", verifyToken, isAdmin, codeController.createCode);
router.get("/", verifyToken, isAdmin, codeController.getAllCodes);
router.get("/:id", verifyToken, isAdmin, codeController.getCodeById);
router.put("/:id", verifyToken, isAdmin, codeController.updateCode);

module.exports = router;
