const express = require("express");
const router = express.Router();
const { verifyToken } = require("../../middleware/authMiddleware");
const {
  getPendingAvailabilityChanges,
  getAvailabilityChangeDetails,
  approveAvailabilityChange,
  rejectAvailabilityChange,
  bulkApproveChanges,
  getAvailabilityApprovalStats
} = require("../../controller/admin/availabilityApprovalController");

// Middleware to ensure only admins can access these routes
const adminOnly = (req, res, next) => {
  if (req.user.role !== 'admin') {
    return res.status(403).json({
      success: false,
      message: "Access denied. Only admins can access this resource."
    });
  }
  next();
};

// Apply auth middleware to all routes
router.use(verifyToken);
router.use(adminOnly);

// Get all pending availability changes
router.get("/pending", getPendingAvailabilityChanges);

// Get specific availability change details for review
router.get("/:availabilityId/changes/:changeId", getAvailabilityChangeDetails);

// Approve availability change
router.post("/:availabilityId/changes/:changeId/approve", approveAvailabilityChange);

// Reject availability change
router.post("/:availabilityId/changes/:changeId/reject", rejectAvailabilityChange);

// Bulk approve multiple changes
router.post("/bulk-approve", bulkApproveChanges);

// Get availability approval statistics
router.get("/stats", getAvailabilityApprovalStats);

module.exports = router;
