const mongoose = require("mongoose");

const planSchema = new mongoose.Schema(
  {
    userId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    doctorId: {
      type: mongoose.Schema.Types.ObjectId,
      ref: "User",
      required: true,
    },
    therapyPlans: {
      type: [String],
      required: true,
    },
    goalPlans: {
      type: [String],
      required: true,
    },

    //per session amount
    amount: {
      type: Number,
      required: true,
    },
    sessionCount: {
      type: Number,
      required: true,
    },
    status: {
      type: String,
      enum: ["pending", "active", "completed", "cancelled"],
      default: "pending",
    },
    unlockedSessions: {
      type: Number,
      default: 0,
    },
    completedSessions: {
      type: Number,
      default: 0,
    },
    completedSessionsIndividual: {
      type: Number,
      default: 0,
    },
    installmentsPaid: {
      type: Number,
      default: 0,
    },
  },
  { timestamps: true }
);

module.exports = mongoose.model("Plans", planSchema);
