const mongoose = require("mongoose");

const eventJoinSchema = new mongoose.Schema({
  event: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "CommunityEvent",
    required: true,
  },
  name: {
    type: String,
    required: true,
    trim: true,
  },
  age: {
    type: Number,
    required: true,
    min: 1,
  },
  city: {
    type: String,
    required: true,
    trim: true,
  },
  educationQualifications: {
    type: String,
    required: true,
    trim: true,
  },
  
  paymentStatus: {
    type: String,
    enum: ["pending", "completed", "failed"],
    default: "pending",
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
});

module.exports = mongoose.model("JoinEvent", eventJoinSchema);

