const mongoose = require("mongoose");

const CodeSchema = new mongoose.Schema({
  code: {
    type: String,
    required: true,
    unique: true,
  },
  description: {
    type: String,
    required: true,
  },
  createdBy: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "User",
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
  isActive: {
    type: Boolean,
    default: true,
  },
  discountPercentage: {
    // New field for discount percentage
    type: Number,
    required: true,
    min: 0, // Minimum value for percentage
    max: 100, // Maximum value for percentage
  },
});

module.exports = mongoose.model("Code", CodeSchema);
