const mongoose = require("mongoose");

const appointmentSchema = new mongoose.Schema({
  date: {
    type: Date,
    required: true,
  },
  timeSlot: {
    startTime: {
      type: String,
      required: true,
      match: /^([01]\d|2[0-3]):([0-5]\d)$/,
    },
    endTime: {
      type: String,
      required: true,
      match: /^([01]\d|2[0-3]):([0-5]\d)$/,
    },
  },
  doctor: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "User",
    required: true,
  },
  founder: {
    type: Boolean,
    default: false,
  },
  patient: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "User",
    required: true,
  },

  meetLink: {
    type: String,
    default: null,
  },
  sessionType: {
    type: String,
    enum: ["Consultation", "Individual Plan", "Package Plan"],
    default: "Consultation",
  },
  mode: {
    type: String,
    enum: ["Online", "Offline"],
    default: "Online",
  },
  tags: [{
    type: String,
    default: []
  }],
  status: {
    type: String,
    enum: ["pending", "scheduled", "completed", "cancelled", "no-show"],
    default: "pending",
  },
  notes: {
    type: String,
    default: null,
  },
  pdf: {
    type: String,
    default: null,
  },

  reminderSent: {
    type: Boolean,
    default: false,
  },
  plan: {
    type: mongoose.Schema.Types.ObjectId,
    ref: "Plans",
    default: null,
  },
  createdAt: {
    type: Date,
    default: Date.now,
  },
});

module.exports = mongoose.model("Appointment", appointmentSchema);
