const multer = require("multer");

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    if (file.fieldname === "image") {
      cb(null, "uploads/events/");
    } else if (file.fieldname === "appointmentPdf") {
      cb(null, "uploads/appointments/");
    } else {
      cb(null, "uploads/others/");
    }
  },
  filename: (req, file, cb) => {
    cb(null, Date.now() + "_" + file.originalname);
  }
});

const upload = multer({ storage });

module.exports = upload;
