require("dotenv").config();
const express = require("express");
const mongoose = require("mongoose");
const path = require("path");
const cors = require("cors");

const app = express();

// CORS Configuration
app.use(cors());

app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(express.static("public"));
app.use("/uploads", express.static("uploads"));
app.use("/reports", express.static(path.join(__dirname, "reports")));
// MongoDB Connection
const MONGO_URI =
  process.env.MONGO_URI ||
  "mongodb+srv://ydubey48_db_user:xCHPPhz0d9ObcDmt@therapy.zbtsngk.mongodb.net/?retryWrites=true&w=majority&appName=Therapy";

mongoose
  .connect(MONGO_URI, {
    useNewUrlParser: true,
  })
  .then(() => console.log("MongoDB Connected"))
  .catch((err) => console.error("MongoDB Connection Error:", err));

// Routes
const authRoute = require("./routes/auth");
app.use("/api/auth", authRoute);

//admin route
const doctor = require("./routes/admin/admin");
const game = require("./routes/admin/game");
const code = require("./routes/admin/code");
const therapistApproval = require("./routes/admin/therapistApprovalRoutes");
const availabilityApproval = require("./routes/admin/availabilityApprovalRoutes");
app.use("/api/admin", doctor);
app.use("/api/game", game);
app.use("/api/code", code);
app.use("/api/admin/therapists", therapistApproval);
app.use("/api/admin/availability", availabilityApproval);

//Doctor route
const session = require("./routes/doctor/session");
const dashboard = require("./routes/doctor/dashboard");
const therapistProfile = require("./routes/doctor/therapistProfileRoutes");
const availability = require("./routes/doctor/availabilityRoutes");
app.use("/api/doctor", session);
app.use("/api/doctor/dashboard", dashboard);
app.use("/api/doctor", therapistProfile);
app.use("/api/doctor/availability", availability);

//user route
const user = require("./routes/user/user");
const gameanswer = require("./routes/user/game");
const appointment = require("./routes/appointmentRoute");
const bundle = require("./routes/user/bundle");
const matching = require("./routes/appointment/matchingRoutes");
app.use("/api/user", user);
app.use("/api/game", gameanswer);
app.use("/api/appointment", appointment);
app.use("/api/appointments", matching);
app.use("/api/user/bundle", bundle);

//community initiative route
const communityInitiative = require("./routes/communityInitiative");
app.use("/api/community", communityInitiative);

const payment = require("./routes/user/payment");
app.use("/api/payment", payment);

//therapy plan routes
const therapyPlan = require("./routes/therapyPlanRoutes");
app.use("/api/therapy-plans", therapyPlan);
console.log("✅ Therapy Plan routes loaded at /api/therapy-plans");

//notification routes
const notifications = require("./routes/notificationRoutes");
app.use("/api/notifications", notifications);
console.log("✅ Notification routes loaded at /api/notifications");

// Google Meet integration is now built into appointment booking

app.get("/", (req, res) => {
  res.send("Hello one");
});

const PORT = process.env.PORT || 2000;
app.listen(PORT, () => {
  console.log(`Server is running on http://localhost:${PORT}`);
});
